#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//fbm and domain wrapingMod01.fsh   by  Eseris
//https://www.shadertoy.com/view/WsjGRz
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// #define DEBUG_PALETTE

float hash21(vec2 v) {
    return fract(sin(dot(v, vec2(12.9898, 78.233))) * 43758.5453123);
}

float noise(vec2 uv) {
	vec2 f = fract(uv);
	vec2 i = floor(uv);
	f = f * f * (3. - 2. * f);
	return mix(
		mix(hash21(i), hash21(i + vec2(1,0)), f.x),
		mix(hash21(i + vec2(0,1)), hash21(i + vec2(1,1)), f.x), f.y);
}

float fbm(vec2 uv) {
	float freq = 2.;
	float amp = .5;
	float gain = .54;
	float v = 0.;
	for(int i = 0; i < 6; ++i) {
		v += amp * noise(uv);
		amp *= gain;
		uv *= freq;
	}
	return v;
}

float fbmPattern(vec2 p, out vec2 q, out vec2 r) {
	float qCoef = 2.;
	float rCoef = 3.;
	q.x = fbm(p             + .0  * iTime);
	q.y = fbm(p             - .02 * iTime + vec2(10., 7.36));
	r.x = fbm(p + qCoef * q + .1  * iTime + vec2(5., 3.));
	r.y = fbm(p + qCoef * q - .07 * iTime + vec2(10., 7.36));
	return fbm(p + rCoef * r + .1 * iTime);
}

vec3 basePalette(float t) {
	return .5 + .6 * cos(6.283185 * (-t + vec3(.0, .1, .2) - .2));
}

vec3 smokePalette(float t) {
	return vec3(.6, .5, .5) 
		+ .5 * cos(6.283185 * (-vec3(1., 1., .5) * t + vec3(.2, .15, -.1) - .2));
}



//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = fragCoord/iResolution.yy;

	float scale = 5.;
	vec3 col = vec3(.1);
	float n;

	vec2 q;
	vec2 r;
	n = fbmPattern(scale * uv, q, r);
	vec3 baseCol = basePalette(r.x);
	vec3 smokeCol = smokePalette(n);

	col = mix(baseCol, smokeCol, pow(q.y, 1.3));

#ifdef DEBUG_PALETTE
    float x = fragCoord.x / iResolution.x;
	col = mix(col, basePalette(x), step(abs(uv.y - .03), .02));
	col = mix(col, smokePalette(x), step(abs(uv.y - .08), .02));
#endif

	fragColor = vec4(col, 1);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

